/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.type;

import java.util.Arrays;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.Geometry;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.LineString;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.Point;

public class Polygon
implements Geometry {
    private final LineString[] lines;

    public Polygon(LineString[] lines) {
        this.lines = lines;
    }

    public LineString[] getLines() {
        return this.lines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("POLYGON(");
        int indexLine = 0;
        for (LineString ls : this.lines) {
            if (indexLine++ > 0) {
                sb.append(",");
            }
            sb.append("(");
            int index = 0;
            for (Point pt : ls.getPoints()) {
                if (index++ > 0) {
                    sb.append(",");
                }
                sb.append(pt.getX()).append(" ").append(pt.getY());
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Polygon)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.lines);
    }
}

